#include<simdheader.h>

#ifndef I_CAN_HAZ_SIMD
#error The correct internal header was not used
#endif

#include<simdconfig.h>
#include<simdfuncs.h>
#include<stdint.h>

#ifdef _MSC_VER
#include<intrin.h>
int avx_available(void) {
  return 1;
}
#else
#include<immintrin.h>
#include<cpuid.h>

#ifdef __APPLE__
/*
 * Apple ships a broken __builtin_cpu_supports and
 * some machines in the CI farm seem to be too
 * old to have AVX so just always return 0 here.
 */
int avx_available(void) { return 0; }
#else

int avx_available(void) {
    return __builtin_cpu_supports("avx");
}
#endif
#endif

void increment_avx(float arr[4]) {
    double darr[4];
    darr[0] = arr[0];
    darr[1] = arr[1];
    darr[2] = arr[2];
    darr[3] = arr[3];
    __m256d val = _mm256_loadu_pd(darr);
    __m256d one = _mm256_set1_pd(1.0);
    __m256d result = _mm256_add_pd(val, one);
    _mm256_storeu_pd(darr, result);
    arr[0] = (float)darr[0];
    arr[1] = (float)darr[1];
    arr[2] = (float)darr[2];
    arr[3] = (float)darr[3];
}
